<?php $__env->startSection('title', $title); ?>
<?php $__env->startSection('content'); ?>


<div class="mb-6">
    <div class="flex flex-col md:flex-row justify-between items-center">
        <div class="mb-3 md:mb-0">
            <h5 class="text-dark-300 dark:text-light-300 text-2xl font-semibold">Your <?php echo e($plan->dplan->name); ?> Plan</h5>
        </div>
    </div>
</div>

<?php if (isset($component)) { $__componentOriginalc254754b9d5db91d5165876f9d051922ca0066f4 = $component; } ?>
<?php $component = $__env->getContainer()->make(Illuminate\View\AnonymousComponent::class, ['view' => 'components.danger-alert','data' => []]); ?>
<?php $component->withName('danger-alert'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php $component->withAttributes([]); ?>
<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__componentOriginalc254754b9d5db91d5165876f9d051922ca0066f4)): ?>
<?php $component = $__componentOriginalc254754b9d5db91d5165876f9d051922ca0066f4; ?>
<?php unset($__componentOriginalc254754b9d5db91d5165876f9d051922ca0066f4); ?>
<?php endif; ?>
<?php if (isset($component)) { $__componentOriginalc254754b9d5db91d5165876f9d051922ca0066f4 = $component; } ?>
<?php $component = $__env->getContainer()->make(Illuminate\View\AnonymousComponent::class, ['view' => 'components.success-alert','data' => []]); ?>
<?php $component->withName('success-alert'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php $component->withAttributes([]); ?>
<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__componentOriginalc254754b9d5db91d5165876f9d051922ca0066f4)): ?>
<?php $component = $__componentOriginalc254754b9d5db91d5165876f9d051922ca0066f4; ?>
<?php unset($__componentOriginalc254754b9d5db91d5165876f9d051922ca0066f4); ?>
<?php endif; ?>

<div class="mt-6">
    <div class="w-full">
        <div class="px-6 py-8 rounded-3xl bg-gradient-to-r from-white/80 to-white/60 dark:from-dark-50/80 dark:to-dark-100/60 backdrop-blur-md border border-white/20 dark:border-dark-200/30 shadow-lg">

            <!-- Back Button -->
            <div class="flex justify-between items-center mb-6">
                <a href="<?php echo e(route('myplans', 'All')); ?>" class="text-base text-dark-300 dark:text-light-300  hover:text-dark dark:hover:text-white focus:outline-none">
                    <i class="fas fa-arrow-circle-left fa-2x p-2 bg-white dark:bg-dark-50 rounded-lg"></i>
                </a>
            </div>

            <!-- Plan Title -->
            <h2 class="text-xl font-bold text-dark-300 dark:text-light-300">
                <?php echo e($plan->dplan->name); ?> -
                <?php echo e($plan->dplan->increment_type === 'Fixed' ? $settings->currency : ''); ?><?php echo e($plan->dplan->increment_amount); ?><?php echo e($plan->dplan->increment_type === 'Percentage' ? '%' : ''); ?>

                <?php echo e($plan->dplan->increment_interval); ?>

                for <?php echo e($plan->dplan->expiration); ?>

            </h2>

            <!-- Plan Status & Cancel Button -->
            <div class="flex justify-between items-center mt-3">
                <div>
                    <?php if($plan->active === 'yes'): ?>
                        <span class="px-3 py-1 text-sm bg-green-200 text-green-800 rounded-full">Active</span>
                    <?php elseif($plan->active === 'expired'): ?>
                        <span class="px-3 py-1 text-sm bg-red-200 text-red-800 rounded-full">Expired</span>
                    <?php else: ?>
                        <span class="px-3 py-1 text-sm bg-red-200 text-red-800 rounded-full">Inactive</span>
                    <?php endif; ?>
                </div>

                <?php if($settings->should_cancel_plan && $plan->active === 'yes'): ?>
                    <button data-toggle="modal" data-target="#exampleModal"
                        class="bg-red-600 text-white text-sm px-4 py-2 rounded hover:bg-red-700 flex items-center">
                        <i class="fas fa-times mr-2"></i> Cancel this Plan
                    </button>

                    <!-- Cancel Modal -->
                    <div class="modal fade" id="exampleModal" tabindex="-1" role="dialog"
                        aria-labelledby="exampleModalLabel" aria-hidden="true">
                        <div class="modal-dialog modal-dialog-centered" role="document">
                            <div class="modal-content">
                                <div class="modal-header">
                                    <h5 class="modal-title">Cancel Plan</h5>
                                    <button type="button" class="close" data-dismiss="modal">
                                        <span>&times;</span>
                                    </button>
                                </div>
                                <div class="modal-body">
                                    Are you sure you want to cancel your <?php echo e($plan->dplan->name); ?> plan?
                                </div>
                                <div class="modal-footer">
                                    <button type="button" class="btn btn-secondary" data-dismiss="modal">Close</button>
                                    <a href="<?php echo e(route('cancelplan', $plan->id)); ?>" class="btn btn-danger">Cancel</a>
                                </div>
                            </div>
                        </div>
                    </div>
                <?php endif; ?>
            </div>

            <hr class="my-6">

            <!-- Plan Summary -->
            <div class="mt-5">
                <h4 class="text-lg font-semibold mb-4">Plan Information</h4>
                <div class="grid md:grid-cols-3 gap-6 mb-6">
                    <div>
                        <h2 class="text-xl font-bold text-base text-dark-300 dark:text-light-300">
                            <?php echo e($settings->currency); ?><?php echo e(number_format($plan->amount, 2)); ?>

                        </h2>
                        <p class="text-sm text-dark-300 dark:text-light-300">Invested Amount</p>
                    </div>
                    <div>
                        <h2 class="text-xl font-bold text-green-600">
                            <?php echo e($settings->currency); ?><?php echo e(number_format($plan->profit_earned, 2)); ?>

                        </h2>
                        <p class="text-sm text-dark-300 dark:text-light-300">Profit Earned</p>
                    </div>
                    <div>
                        <h2 class="text-xl font-bold text-green-700">
                            <?php if($settings->return_capital): ?>
                                <?php echo e($settings->currency); ?><?php echo e(number_format($plan->amount + $plan->profit_earned, 2)); ?>

                            <?php else: ?>
                                <?php echo e($settings->currency); ?><?php echo e(number_format($plan->profit_earned, 2)); ?>

                            <?php endif; ?>
                        </h2>
                        <p class="text-sm text-dark-300 dark:text-light-300">Total Return</p>
                    </div>
                </div>

                <!-- Dates and Details -->
                <div class="grid md:grid-cols-3 gap-4 border-b pb-4">
                    <div>
                        <p class="text-base text-dark-300 dark:text-light-300">Duration</p>
                        <strong><?php echo e($plan->dplan->expiration); ?></strong>
                    </div>
                    <div>
                        <p class="text-base text-dark-300 dark:text-light-300">Start Date</p>
                        <strong><?php echo e($plan->created_at->addHour()->toDayDateTimeString()); ?></strong>
                    </div>
                    <div>
                        <p class="text-base text-dark-300 dark:text-light-300">End Date</p>
                        <strong><?php echo e(\Carbon\Carbon::parse($plan->expire_date)->addHour()->toDayDateTimeString()); ?></strong>
                    </div>
                </div>

                <div class="grid md:grid-cols-3 gap-4 border-b mt-4 pb-4">
                    <div>
                        <p class="text-base text-dark-300 dark:text-light-300">Minimum Return</p>
                        <strong><?php echo e($plan->dplan->minr); ?>%</strong>
                    </div>
                    <div>
                        <p class="text-base text-dark-300 dark:text-light-300">Maximum Return</p>
                        <strong><?php echo e($plan->dplan->maxr); ?>%</strong>
                    </div>
                    <div>
                        <p class="text-base text-dark-300 dark:text-light-300">ROI Interval</p>
                        <strong><?php echo e($plan->dplan->increment_interval); ?></strong>
                    </div>
                </div>
            </div>

            <!-- Transaction History -->
            <div class="mt-6">
                <h4 class="text-lg font-semibold mb-4">Transactions</h4>
                <div class="overflow-x-auto">
                    <table class="min-w-full text-left text-sm">
                        <thead class="bg-white dark:bg-dark-50 text-base text-dark-300 dark:text-light-300">
                            <tr>
                                <th class="py-2 px-4">Type</th>
                                <th class="py-2 px-4">Date</th>
                                <th class="py-2 px-4">Amount</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php $__empty_1 = true; $__currentLoopData = $transactions; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $history): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                                <tr class="border-b">
                                    <td class="py-2 px-4">Profit</td>
                                    <td class="py-2 px-4"><?php echo e($history->created_at->addHour()->toDayDateTimeString()); ?></td>
                                    <td class="py-2 px-4">
                                        <?php echo e($settings->currency); ?><?php echo e(number_format($history->amount, 2)); ?>

                                    </td>
                                </tr>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                                <tr>
                                    <td colspan="3" class="text-center py-4 text-dark-300 dark:text-light-300">No transaction record yet</td>
                                </tr>
                            <?php endif; ?>
                        </tbody>
                    </table>
                </div>
                <div class="mt-4">
                    <?php echo e($transactions->links()); ?>

                </div>
            </div>

        </div>
    </div>
</div>
<div class="mt-6">
    <div class="flex justify-between items-center">
        <a href="<?php echo e(route('myplans', 'All')); ?>" class="text-base text-dark-300 dark:text-light-300  hover:text-dark dark:hover:text-white focus:outline-none">
            <i class="fas fa-arrow-circle-left fa-2x p-2 bg-white dark:bg-dark-50 rounded-lg"></i>
        </a>
    </div>

<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.dash', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\xampp\htdocs\trading\resources\views/user/plandetails.blade.php ENDPATH**/ ?>