<!-- Enhanced Top Navigation Bar -->
<header class="flex h-16 items-center justify-between dark:border-dark-100 border-light-200 border-b px-4 sm:px-6 sticky top-0 z-[9999] bg-gradient-to-r dark:from-dark dark:to-dark-50 from-light to-light-100 backdrop-blur-sm shadow-md">
    <div class="flex items-center gap-4">
        <!-- Mobile Menu Toggle with Improved Design -->
        <button class="md:hidden dark:text-white text-dark p-1.5 rounded-lg dark:hover:bg-dark-100/60 hover:bg-light-200/60 transition-colors focus:outline-none focus:ring-2 focus:ring-primary/50" id="mobileMenuToggle">
            <i data-lucide="menu" class="h-5 w-5"></i>
        </button>
        
        <!-- Mobile Logo with Enhanced Appearance -->
        <div class="flex items-center gap-3 md:hidden">
            <div class="flex items-center gap-2 font-bold text-xl md:hidden">
            <img src="<?php echo e(asset('storage/app/public/' . $settings->logo)); ?>" alt="logo" class="h-8">
        </div>
        </div>
    </div>
    
    <!-- Right-side items with Better Layout -->
    <div class="flex items-center gap-1.5 sm:gap-3">
        <!-- Theme Toggle Button -->
        <button id="themeToggle" onclick="toggleTheme()" class="p-1.5 dark:text-gray-300 text-gray-700 hover:text-dark dark:hover:text-white dark:bg-dark-100/40 bg-light-200/40 hover:bg-light-200/80 dark:hover:bg-dark-100/80 rounded-lg transition-colors" title="Toggle Theme">
            <!-- Sun icon for light theme (shown in dark mode) -->
            <i data-lucide="sun" class="h-4 w-4"></i>
            <!-- Moon icon for dark theme (shown in light mode) -->
            <i data-lucide="moon" class="h-4 w-4"></i>
        </button>
        
        <!-- KYC Verification with Improved Design -->
        <?php if($settings->enable_kyc == 'yes'): ?>
        <div class="relative" x-data="{ open: false }">
            <?php if(Auth::user()->account_verify == 'Verified'): ?>
            <div class="flex items-center text-secondary bg-secondary/10 px-2 py-1 rounded-lg text-xs border border-secondary/20">
                <i data-lucide="shield-check" class="h-3.5 w-3.5 mr-1"></i>
                <span class="hidden sm:inline-block">Verified</span>
            </div>
            <?php else: ?>
            <button @click="open = !open" class="flex items-center dark:text-gray-300 text-gray-700 hover:text-dark dark:hover:text-white dark:bg-dark-100/40 bg-light-200/40 hover:bg-light-200/80 dark:hover:bg-dark-100/80 px-2 py-1 rounded-lg text-xs dark:border-dark-100 border-light-200 border transition-colors">
                <i data-lucide="shield" class="h-3.5 w-3.5 mr-1"></i>
                <span class="hidden sm:inline-block">KYC</span>
            </button>
            <div x-show="open" @click.away="open = false" class="absolute right-0 mt-2 w-56 dark:bg-dark-50 bg-light-100 dark:border-dark-100 border-light-200 border rounded-lg shadow-lg overflow-hidden z-[10000]">
                <div class="bg-gradient-to-r dark:from-dark-100 dark:to-dark-100/30 from-light-200 to-light-200/30 px-4 py-3 dark:border-dark-100 border-light-200 border-b">
                    <h6 class="text-sm font-medium dark:text-white text-dark">KYC Verification</h6>
                    <p class="text-xs dark:text-gray-400 text-gray-600 mt-0.5">Verify your identity to unlock all features</p>
                </div>
                <div class="p-4 text-center">
                    <?php if(Auth::user()->account_verify == 'Under review'): ?>
                        <div class="dark:bg-dark-100/40 bg-light-200/40 rounded-lg p-3 mb-2">
                            <i data-lucide="clock" class="h-8 w-8 text-primary mx-auto mb-2"></i>
                            <span class="text-xs dark:text-gray-300 text-gray-700 block">Your submission is under review</span>
                        </div>
                        <p class="text-xs dark:text-gray-400 text-gray-600 mt-2">We'll notify you once verification is complete</p>
                    <?php else: ?>
                        <div class="dark:bg-dark-100/40 bg-light-200/40 rounded-lg p-3 mb-3">
                            <i data-lucide="shield-alert" class="h-8 w-8 text-primary mx-auto mb-2"></i>
                            <span class="text-xs dark:text-gray-300 text-gray-700 block">Your account is not verified</span>
                        </div>
                        <a href="<?php echo e(route('account.verify')); ?>" class="inline-flex items-center justify-center gap-1.5 bg-gradient-to-r from-primary to-primary/80 text-white text-xs font-medium px-4 py-2 rounded-lg hover:from-primary/90 hover:to-primary/70 transition-all">
                            <i data-lucide="shield-check" class="h-3.5 w-3.5"></i>
                            <span>Verify Account</span>
                        </a>
                    <?php endif; ?>
                </div>
            </div>
            <?php endif; ?>
        </div>
        <?php endif; ?>
        
        <!-- Notifications with Enhanced Design -->
        <div class="relative" x-data="{ open: false }">
            <button @click="open = !open" class="p-1.5 dark:text-gray-300 text-gray-700 hover:text-dark dark:hover:text-white dark:bg-dark-100/40 bg-light-200/40 hover:bg-light-200/80 dark:hover:bg-dark-100/80 rounded-lg transition-colors relative" title="Notifications">
                <i data-lucide="bell" class="h-4 w-4"></i>
                <span class="absolute -right-1 -top-1 h-4 w-4 flex items-center justify-center bg-primary text-[10px] rounded-full dark:border-dark border-light-100 border">3</span>
            </button>
            
            <div x-show="open" @click.away="open = false" class="absolute right-0 mt-2 w-72 dark:bg-dark-50 bg-light-100 dark:border-dark-100 border-light-200 border rounded-lg shadow-lg overflow-hidden z-[10000]">
                <div class="bg-gradient-to-r dark:from-dark-100 dark:to-dark-100/30 from-light-200 to-light-200/30 px-4 py-3 flex items-center justify-between dark:border-dark-100 border-light-200 border-b">
                    <h6 class="text-sm font-medium dark:text-white text-dark">Notifications</h6>
                    <span class="text-xs bg-primary text-white px-1.5 py-0.5 rounded-full">3 new</span>
                </div>
                <div class="max-h-[280px] overflow-y-auto">
                    <!-- Sample notifications -->
                    <div class="p-3 dark:border-dark-100/60 border-light-200/60 border-b hover:bg-dark-100/30 dark:hover:bg-dark-100/30 hover:bg-light-200/30 transition-colors">
                        <div class="flex gap-3">
                            <div class="h-8 w-8 rounded-full bg-secondary/10 flex items-center justify-center flex-shrink-0">
                                <i data-lucide="check-circle" class="h-4 w-4 text-secondary"></i>
                            </div>
                            <div>
                                <p class="text-xs dark:text-white text-dark">Your deposit of <span class="font-medium">$250.00</span> has been confirmed</p>
                                <p class="text-xs dark:text-gray-400 text-gray-600 mt-1">2 hours ago</p>
                            </div>
                        </div>
                    </div>
                    <div class="p-3 dark:border-dark-100/60 border-light-200/60 border-b hover:bg-dark-100/30 dark:hover:bg-dark-100/30 hover:bg-light-200/30 transition-colors">
                        <div class="flex gap-3">
                            <div class="h-8 w-8 rounded-full bg-primary/10 flex items-center justify-center flex-shrink-0">
                                <i data-lucide="trending-up" class="h-4 w-4 text-primary"></i>
                            </div>
                            <div>
                                <p class="text-xs dark:text-white text-dark">You earned <span class="font-medium">$12.50</span> from your investment</p>
                                <p class="text-xs dark:text-gray-400 text-gray-600 mt-1">Yesterday</p>
                            </div>
                        </div>
                    </div>
                    <div class="p-3 hover:bg-dark-100/30 dark:hover:bg-dark-100/30 hover:bg-light-200/30 transition-colors">
                        <div class="flex gap-3">
                            <div class="h-8 w-8 rounded-full bg-tertiary/10 flex items-center justify-center flex-shrink-0">
                                <i data-lucide="bell" class="h-4 w-4 text-tertiary"></i>
                            </div>
                            <div>
                                <p class="text-xs dark:text-white text-dark">Welcome to <?php echo e($settings->site_name); ?>! Complete your profile setup.</p>
                                <p class="text-xs dark:text-gray-400 text-gray-600 mt-1">3 days ago</p>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="p-2 dark:border-dark-100 border-light-200 border-t">
                    <a href="#" class="block text-xs text-center text-primary hover:text-primary/80 py-1">
                        View all notifications
                    </a>
                </div>
            </div>
        </div>
        
        <!-- User Profile Dropdown with Enhanced Design -->
        <div class="relative" x-data="{ open: false }">
            <button @click="open = !open" class="flex items-center gap-2 p-1 rounded-lg hover:bg-dark-100/40 dark:hover:bg-dark-100/40 hover:bg-light-200/40 transition-colors">
                <div class="relative">
                    <div class="absolute inset-0 bg-gradient-to-r from-primary to-secondary rounded-full opacity-80"></div>
                    <div class="relative h-7 w-7 sm:h-8 sm:w-8 bg-primary rounded-full flex items-center justify-center text-sm font-medium dark:border-dark-50 border-light-300 border-2">
                        <?php echo e(substr(Auth::user()->name, 0, 2)); ?>

                    </div>
                </div>
                <span class="hidden md:block text-sm font-medium dark:text-white text-dark"><?php echo e(Auth::user()->username); ?></span>
                <i data-lucide="chevron-down" class="h-4 w-4 dark:text-gray-400 text-gray-600 hidden md:block"></i>
            </button>
            
            <div x-show="open" @click.away="open = false" class="absolute right-0 mt-2 w-56 dark:bg-dark-50 bg-light-100 dark:border-dark-100 border-light-200 border rounded-lg shadow-lg overflow-hidden z-[10000]">
                <div class="bg-gradient-to-r dark:from-dark-100 dark:to-dark-100/30 from-light-200 to-light-200/30 px-4 py-3 dark:border-dark-100 border-light-200 border-b">
                    <h6 class="text-sm font-medium dark:text-white text-dark"><?php echo e(Auth::user()->name); ?></h6>
                    <p class="text-xs dark:text-gray-400 text-gray-600 mt-0.5"><?php echo e(Auth::user()->email); ?></p>
                </div>
                
                <div class="py-2">
                    <a href="<?php echo e(route('profile')); ?>" class="flex items-center gap-2 px-4 py-2 text-sm dark:text-gray-300 text-gray-700 dark:hover:bg-dark-100/60 hover:bg-light-200/60 transition-colors">
                        <i data-lucide="user" class="h-4 w-4 dark:text-gray-400 text-gray-600"></i>
                        <span>My Profile</span>
                    </a>
                    <a href="<?php echo e(route('accounthistory')); ?>" class="flex items-center gap-2 px-4 py-2 text-sm dark:text-gray-300 text-gray-700 dark:hover:bg-dark-100/60 hover:bg-light-200/60 transition-colors">
                        <i data-lucide="history" class="h-4 w-4 dark:text-gray-400 text-gray-600"></i>
                        <span>Transaction History</span>
                    </a>
                    <a href="<?php echo e(route('support')); ?>" class="flex items-center gap-2 px-4 py-2 text-sm dark:text-gray-300 text-gray-700 dark:hover:bg-dark-100/60 hover:bg-light-200/60 transition-colors">
                        <i data-lucide="life-buoy" class="h-4 w-4 dark:text-gray-400 text-gray-600"></i>
                        <span>Support</span>
                    </a>
                </div>
                
                <div class="py-2 dark:border-dark-100 border-light-200 border-t">
                    <a href="<?php echo e(route('logout')); ?>" 
                       onclick="event.preventDefault(); document.getElementById('logout-form').submit();"
                       class="flex items-center gap-2 px-4 py-2 text-sm text-danger hover:bg-dark-100/60 dark:hover:bg-dark-100/60 hover:bg-light-200/60 transition-colors">
                        <i data-lucide="log-out" class="h-4 w-4"></i>
                        <span>Logout</span>
                    </a>
                    <form id="logout-form" action="<?php echo e(route('logout')); ?>" method="POST" class="hidden">
                        <?php echo e(csrf_field()); ?>

                    </form>
                </div>
            </div>
        </div>
    </div>
</header>

<!-- Welcome Message with Enhanced Design -->
<?php if(!empty($settings->welcome_message) and Auth::user()->created_at->diffInDays() <= 3): ?>
<div id="welcome-message" class="fixed top-20 left-1/2 transform -translate-x-1/2 z-[9998] bg-gradient-to-r from-primary to-primary/90 rounded-lg shadow-lg max-w-md w-[90%] animate-in slide-in-from-top duration-300">
    <div class="relative overflow-hidden p-4 rounded-lg">
        <!-- Decorative elements -->
        <div class="absolute top-0 right-0 w-20 h-20 bg-white opacity-5 rounded-full transform translate-x-8 -translate-y-8"></div>
        <div class="absolute bottom-0 left-0 w-16 h-16 bg-white opacity-5 rounded-full transform -translate-x-6 translate-y-6"></div>
        
        <div class="flex items-start">
            <div class="flex-shrink-0 mr-3">
                <div class="h-9 w-9 bg-white/10 rounded-full flex items-center justify-center">
                    <i data-lucide="party-popper" class="h-5 w-5 text-white"></i>
                </div>
            </div>
            <div class="flex-1">
                <p class="text-white font-medium text-sm"><?php echo e($settings->welcome_message); ?></p>
            </div>
            <button onclick="document.getElementById('welcome-message').style.display='none'" class="ml-2 p-1 rounded-full hover:bg-white/10 transition-colors flex-shrink-0">
                <i data-lucide="x" class="h-4 w-4 text-white"></i>
            </button>
        </div>
    </div>
</div>
<?php endif; ?><?php /**PATH /home7/ticketie/public_html/resources/views/user/topmenu.blade.php ENDPATH**/ ?>