<?php
    if ($settings->redirect_url != null or !empty($settings->redirect_url)) {
        header("Location: $settings->redirect_url", true, 301);
        exit();
    }
    
    use App\Models\Plans;
    $plans = Plans::where('type', 'main')->get();
?>
<!DOCTYPE html>
<html lang="zxx">

<head>
	<!-- Meta -->
	<meta charset="utf-8">
	<meta http-equiv="X-UA-Compatible" content="IE=edge">
	<meta name="viewport" content="width=device-width, initial-scale=1.0">
	<meta name="description" content="">
	<meta name="keywords" content="">
	<meta name="author" content="Awaiken">
	<!-- Page Title -->
	<title><?php echo e($settings->site_name); ?>|Profit-oriented solutions, crafted with elegance and finesse</title>
	<!-- Favicon Icon -->
	<link rel="shortcut icon" type="image/x-icon" href="<?php echo e(asset('storage/app/public/'.$settings->favicon)); ?>">
	<!-- Google Fonts css-->
	<link rel="preconnect" href="https://fonts.googleapis.com/">
	<link rel="preconnect" href="https://fonts.gstatic.com/" crossorigin>
	<link href="https://fonts.googleapis.com/css2?family=DM+Sans:opsz,wght@9..40,100..1000&amp;display=swap" rel="stylesheet">
	<!-- Bootstrap css -->
	<link href="public/m/css/bootstrap.min.css" rel="stylesheet" media="screen">
	<!-- SlickNav css -->
	<link href="public/m/css/slicknav.min.css" rel="stylesheet">
	<!-- Swiper css -->
	<link rel="stylesheet" href="public/m/css/swiper-bundle.min.css">
	<!-- Font Awesome icon css-->
	<link href="public/m/css/all.min.css" rel="stylesheet" media="screen">
	<!-- Animated css -->
	<link href="public/m/css/animate.css" rel="stylesheet">
	<!-- Magnific css -->
	<link href="public/m/css/magnific-popup.css" rel="stylesheet">
	<!-- Main custom css -->
	<link href="public/m/css/custom.css" rel="stylesheet" media="screen">
</head>

<body class="tt-magic-cursor">

	<!-- Preloader Start -->
	<div class="preloader">
		<div class="loading-container">
			<div class="loading"></div>
			<div id="loading-icon"><img src="<?php echo e(asset('storage/app/public/'.$settings->favicon)); ?>" alt=""></div>
		</div>
	</div>
	<!-- Preloader End -->

	<!-- Magic Cursor Start -->
	<div id="magic-cursor">
		<div id="ball"></div>
	</div>
	<!-- Magic Cursor End -->

	<!-- Header Start -->
	<header class="main-header">
		<div class="header-sticky">
			<nav class="navbar navbar-expand-lg">
				<div class="container">
					<!-- Logo Start -->
					<a class="navbar-brand" href="index.html">
						<img src="<?php echo e(asset('storage/app/public/'.$settings->logo)); ?>" height="70" width="136" alt="Logo">
					</a>
					<!-- Logo End -->

					<!-- Main Menu start -->
					<div class="collapse navbar-collapse main-menu">
						<ul class="navbar-nav mr-auto" id="menu">
							<li class="nav-item"><a class="nav-link" href="/">Home</a></li>
							<li class="nav-item"><a class="nav-link" href="about">About us</a></li>
							
							<li class="nav-item"><a class="nav-link" href="contact">Contact</a></li>
							<li class="nav-item"><a class="nav-link" href="register">Create Account</a></li>
							<li class="nav-item highlighted-menu"><a class="nav-link" href="login">Sign in</a></li>
						</ul>
					</div>
					<!-- Main Menu End -->

					<div class="navbar-toggle"></div>
				</div>
			</nav>

			<div class="responsive-menu"></div>
		</div>
	</header>
	<!-- Header End -->

	<!-- Hero Section Start -->
	<div class="hero parallaxie">
		<div class="container">
			<div class="row align-items-center">
				<div class="col-12">
					<!-- Hero Left Content Start -->
					<div class="hero-content">
						<div class="section-title">
							<h3 class="wow fadeInUp">Welcome to <?php echo e($settings->site_name); ?></h3>
							<h1 class="text-anime">A Straightforward Route to Success</h1>
						</div>
						<div class="hero-content-body wow fadeInUp" data-wow-delay="0.5s">
							<p><?php echo e($settings->site_name); ?> We make cryptocurrency simple, secure, and accessible for everyone — from beginners to seasoned traders. Start your journey today</p>
						</div>

						<div class="hero-content-footer wow fadeInUp" data-wow-delay="0.75s">
							<a href="register" class="btn-default">Get Started for Free</a>
						</div>
					</div>
					<!-- Hero Left Content End -->
				</div>
			</div>
		</div>
	</div>
	<!-- Hero Section End -->

	<!-- Coin Ticker Start -->
	<div class="coin-ticker">
		<div class="container-fluid">
			<div class="row no-gap">
				<div class="col-md-12">
					<!-- Coin Ticker Box Start -->
					<div class="coin-ticker-box">
						<div class="scrolling-ticker-box">
							<div class="scrolling-content">
								<div class="scrolling-item">
									<div class="icon-box">
										<img src="public/m/images/icon-ticker-1.svg" alt="">
									</div>

									<p>Bitcoin</p>
								</div>

								<div class="scrolling-item">
									<div class="icon-box">
										<img src="public/m/images/icon-ticker-2.svg" alt="">
									</div>

									<p>Etherium</p>
								</div>

								<div class="scrolling-item">
									<div class="icon-box">
										<img src="public/m/images/icon-ticker-3.svg" alt="">
									</div>

									<p>Tether</p>
								</div>

								<div class="scrolling-item">
									<div class="icon-box">
										<img src="public/m/images/icon-ticker-4.svg" alt="">
									</div>

									<p>BNB</p>
								</div>

								<div class="scrolling-item">
									<div class="icon-box">
										<img src="public/m/images/icon-ticker-5.svg" alt="">
									</div>

									<p>Solana</p>
								</div>

								<div class="scrolling-item">
									<div class="icon-box">
										<img src="public/m/images/icon-ticker-6.svg" alt="">
									</div>

									<p>USD Coin</p>
								</div>

								<div class="scrolling-item">
									<div class="icon-box">
										<img src="public/m/images/icon-ticker-7.svg" alt="">
									</div>

									<p>Cardano</p>
								</div>

								<div class="scrolling-item">
									<div class="icon-box">
										<img src="public/m/images/icon-ticker-8.svg" alt="">
									</div>

									<p>Cardano</p>
								</div>

								<div class="scrolling-item">
									<div class="icon-box">
										<img src="public/m/images/icon-ticker-9.svg" alt="">
									</div>

									<p>Dogecoin</p>
								</div>

								<div class="scrolling-item">
									<div class="icon-box">
										<img src="public/m/images/icon-ticker-10.svg" alt="">
									</div>

									<p>Tron</p>
								</div>

								<div class="scrolling-item">
									<div class="icon-box">
										<img src="public/m/images/icon-ticker-11.svg" alt="">
									</div>

									<p>Polygon</p>
								</div>

								<div class="scrolling-item">
									<div class="icon-box">
										<img src="public/m/images/icon-ticker-12.svg" alt="">
									</div>

									<p>Shiba INU</p>
								</div>

								<div class="scrolling-item">
									<div class="icon-box">
										<img src="public/m/images/icon-ticker-13.svg" alt="">
									</div>

									<p>Lite Coin</p>
								</div>

								<div class="scrolling-item">
									<div class="icon-box">
										<img src="public/m/images/icon-ticker-14.svg" alt="">
									</div>

									<p>Stacks</p>
								</div>
							</div>	

							<div class="scrolling-content">
								<div class="scrolling-item">
									<div class="icon-box">
										<img src="public/m/images/icon-ticker-1.svg" alt="">
									</div>

									<p>Bitcoin</p>
								</div>

								<div class="scrolling-item">
									<div class="icon-box">
										<img src="public/m/images/icon-ticker-2.svg" alt="">
									</div>

									<p>Etherium</p>
								</div>

								<div class="scrolling-item">
									<div class="icon-box">
										<img src="public/m/images/icon-ticker-3.svg" alt="">
									</div>

									<p>Tether</p>
								</div>

								<div class="scrolling-item">
									<div class="icon-box">
										<img src="public/m/images/icon-ticker-4.svg" alt="">
									</div>

									<p>BNB</p>
								</div>

								<div class="scrolling-item">
									<div class="icon-box">
										<img src="public/m/images/icon-ticker-5.svg" alt="">
									</div>

									<p>Solana</p>
								</div>

								<div class="scrolling-item">
									<div class="icon-box">
										<img src="public/m/images/icon-ticker-6.svg" alt="">
									</div>

									<p>USD Coin</p>
								</div>

								<div class="scrolling-item">
									<div class="icon-box">
										<img src="public/m/images/icon-ticker-7.svg" alt="">
									</div>

									<p>Cardano</p>
								</div>

								<div class="scrolling-item">
									<div class="icon-box">
										<img src="public/m/images/icon-ticker-8.svg" alt="">
									</div>

									<p>Cardano</p>
								</div>

								<div class="scrolling-item">
									<div class="icon-box">
										<img src="public/m/images/icon-ticker-9.svg" alt="">
									</div>

									<p>Dogecoin</p>
								</div>

								<div class="scrolling-item">
									<div class="icon-box">
										<img src="public/m/images/icon-ticker-10.svg" alt="">
									</div>

									<p>Tron</p>
								</div>

								<div class="scrolling-item">
									<div class="icon-box">
										<img src="public/m/images/icon-ticker-11.svg" alt="">
									</div>

									<p>Polygon</p>
								</div>

								<div class="scrolling-item">
									<div class="icon-box">
										<img src="public/m/images/icon-ticker-12.svg" alt="">
									</div>

									<p>Shiba INU</p>
								</div>

								<div class="scrolling-item">
									<div class="icon-box">
										<img src="public/m/images/icon-ticker-13.svg" alt="">
									</div>

									<p>Lite Coin</p>
								</div>

								<div class="scrolling-item">
									<div class="icon-box">
										<img src="public/m/images/icon-ticker-14.svg" alt="">
									</div>

									<p>Stacks</p>
								</div>
							</div>						
						</div>
					</div>
					<!-- Coin Ticker Box End -->
				</div>
			</div>
		</div>
	</div>
	<!-- Coin Ticker End -->

	<!-- About us Section Start -->
	<div class="about-us">
		<div class="container">
			<div class="row">
				<div class="col-md-12">
					<!-- Section Title Start -->
					<div class="section-title">
						<h3 class="wow fadeInUp">About <?php echo e($settings->site_name); ?></h3>
						<h2 class="text-anime">Crypto made simple, fast, and secure</h2>
					</div>
					<!-- Section Title End -->
				</div>
			</div>

			<div class="row align-items-center">
				<div class="col-lg-6 col-12">
					<!-- About Images Start -->
					<div class="about-images">
						<div class="about-image">
							<figure class="image-anime reveal">
								<img src="public/m/images/about-us-1.jpg" alt="">
							</figure>
						</div>

						<div class="about-image">
							<figure class="image-anime reveal">
								<img src="public/m/images/about-us-2.jpg" alt="">
							</figure>

							<div class="about-info-item wow fadeInUp" data-wow-delay="0.5s">
								<div class="icon-box">
									<img src="public/m/images/icon-bitcoin-exchange.svg" alt="">
								</div>

								<h5>Bitcoin Exchange</h5>
							</div>
						</div>
					</div>
					<!-- About Images End -->
				</div>

				<div class="col-lg-6 col-12">
					<!-- About Content Start -->
					<div class="about-content">
						<div class="about-body wow fadeInUp" data-wow-delay="0.25s">
							<p><?php echo e($settings->site_name); ?> Our platform is built to empower users with a seamless trading experience, blending advanced security and intuitive tools to help you trade, convert, and grow your assets effortlessly</p>

							<p>With features like automatic conversions and multi-asset support, <?php echo e($settings->site_name); ?> empowers you to manage your portfolio your way — anytime, anywhere</p>
						</div>

						<div class="about-list-item wow fadeInUp" data-wow-delay="0.5s">
							<ul>
								<li>Designed for everyone, from beginners to experts</li>
								<li>Trade anytime, keep pace with your life</li>
								<li>Everything you need, all in one place</li>
								<li>Effortless automatic conversion</li>
								<li>Trade across multiple asset classes effortlessly</li>
								<li>Simple and straightforward to manage</li>
								<li>Scan. Convert. Secure</li>
								<li>Effortless and quick setup</li>
							</ul>
						</div>

						<div class="about-footer wow fadeInUp" data-wow-delay="0.75s">
							<a href="#" class="btn-default">Read More</a>
						</div>
					</div>
					<!-- About Content End -->
				</div>
			</div>
		</div>
	</div>
	<!-- About us Section End -->

	<!-- How It Works Section Start -->
	<div class="how-it-works">
		<div class="container">
			<div class="row">
				<div class="col-md-12">
					<!-- Section Title Start -->
					<div class="section-title">
						<h3 class="wow fadeInUp">How it Works</h3>
						<h2 class="text-anime">Get Started Today with <?php echo e($settings->site_name); ?></h2>
					</div>
					<!-- Section Title End -->
				</div>
			</div>

			<div class="row">
				<div class="col-md-4">
					<!-- How It Work Item Start -->
					<div class="how-it-works-item wow fadeInUp" data-wow-delay="0.25s">
						<div class="icon-box">
							<img src="public/m/images/icon-how-it-work-1.svg" alt="">
						</div>

						<h3>Download the Bitcoin Wallet App</h3>
						<p>Download for PC or mobile to effortlessly create, send, and receive bitcoins</p>
					</div>
					<!-- How It Work Item End -->
				</div>

				<div class="col-md-4">
					<!-- How It Work Item Start -->
					<div class="how-it-works-item wow fadeInUp" data-wow-delay="0.5s">
						<div class="icon-box">
							<img src="public/m/images/icon-how-it-work-2.svg" alt="">
						</div>

						<h3>Fund Your Wallet with Coins</h3>
						<p>Deposit bitcoins you’ve mined or bought with your credit card.</p>
					</div>
					<!-- How It Work Item End -->
				</div>

				<div class="col-md-4">
					<!-- How It Work Item Start -->
					<div class="how-it-works-item wow fadeInUp" data-wow-delay="0.75s">
						<div class="icon-box">
							<img src="public/m/images/icon-how-it-work-3.svg" alt="">
						</div>

						<h3>Buy and Sell with Your Wallet</h3>
						<p>Enter the recipient’s address, specify the amount, and send."

Slightly more formal</p>
					</div>
					<!-- How It Work Item End -->
				</div>
			</div>
		</div>
	</div>
	<!-- How It Works Section End -->

	<!-- Our Services Section Start -->
	<div class="our-services">
		<div class="container">
			<div class="row">
				<div class="col-md-12">
					<!-- Section Title Start -->
					<div class="section-title">
						<h3 class="wow fadeInUp">What We Offer</h3>
						<h2 class="text-anime">Discover the Services Offered by <?php echo e($settings->site_name); ?></h2>
					</div>
					<!-- Section Title End -->
				</div>
			</div>

			<div class="row">
				<div class="col-lg-4 col-md-6">
					<!-- Service Item Start -->
					<div class="service-item wow fadeInUp" data-wow-delay="0.25s">
						<div class="icon-box">
							<img src="public/m/images/icon-our-services-1.svg" alt="">
						</div>

						<h3>Smart and Efficient Trading Modules</h3>
						<p>Enhance your profits through AI-powered strategies With AI-powered automated trading tools that analyze market trends and execute trades at the right moments, you can seize opportunities even while you sleep</p>
					</div>
					<!-- Service Item End -->
				</div>

				<div class="col-lg-4 col-md-6">
					<!-- Service Item Start -->
					<div class="service-item active wow fadeInUp" data-wow-delay="0.5s">
						<div class="icon-box">
							<img src="public/m/images/icon-our-services-2.svg" alt="">
						</div>

						<h3>Intelligent Social Assistant</h3>
						<p>Stay ahead by trading smarter with real-time sentiment analysis. Track social media chatter, news updates, and influencer signals to predict market shifts before they occur</p>
					</div>
					<!-- Service Item End -->
				</div>

				<div class="col-lg-4 col-md-6">
					<!-- Service Item Start -->
					<div class="service-item wow fadeInUp" data-wow-delay="0.75s">
						<div class="icon-box">
							<img src="public/m/images/icon-our-services-3.svg" alt="">
						</div>

						<h3>Powerful AI-Driven News Analyzer</h3>
						<p>Turn headlines into actionable insights. Our AI analyzes global news, earnings reports, and regulatory updates to predict crypto volatility and recommend strategic moves</p>
					</div>
					<!-- Service Item End -->
				</div>

				<div class="col-lg-4 col-md-6">
					<!-- Service Item Start -->
					<div class="service-item wow fadeInUp" data-wow-delay="1.0s">
						<div class="icon-box">
							<img src="public/m/images/icon-our-services-4.svg" alt="">
						</div>

						<h3>Advanced Exchange Order Management</h3>
						<p>Effortless control across platforms. Manage orders, set stop-loss limits, and synchronize trades across multiple exchanges from a single intuitive dashboard
						</p>
					</div>
					<!-- Service Item End -->
				</div>

				<div class="col-lg-4 col-md-6">
					<!-- Service Item Start -->
					<div class="service-item wow fadeInUp" data-wow-delay="1.25s">
						<div class="icon-box">
							<img src="public/m/images/icon-our-services-5.svg" alt="">
						</div>

						<h3>Real-Time Price Alert Module</h3>
						<p>Stay ahead of the market. Get real-time SMS and email alerts when your chosen assets hit critical price levels—enabling you to act instantly
						</p>
					</div>
					<!-- Service Item End -->
				</div>

				<div class="col-lg-4 col-md-6">
					<!-- Service Item Start -->
					<div class="service-item wow fadeInUp" data-wow-delay="1.50s">
						<div class="icon-box">
							<img src="public/m/images/icon-our-services-6.svg" alt="">
						</div>

						<h3>All-in-One Crypto Trading Platform</h3>
						<p>Access 100+ coins with pro-level tools. Benefit from low fees, fast execution, and deep liquidity — whether you're just starting or already experienced</p>
</div>
					<!-- Service Item End -->
				</div>
			</div>
		</div>
	</div>
	<!-- Our Services Section End -->

	<!-- Price Section Start -->
	<div class="price-section">
		<div class="container-fluid">
			<div class="row">
				<div class="col-md-12">
					<!-- Section Title Start -->
					<div class="section-title">
						<h3 class="wow fadeInUp">Price</h3>
						<h2 class="text-anime">Discover Market Prices for Cryptocurrencies</h2>
					</div>
					<!-- Section Title End -->
				</div>
			</div>

			<div class="row no-gap">
				<div class="col-md-12">
					<!-- Price Carousel Start -->
					<div class="price-carousel price-carousel-left ">
						<div class="swiper">
							<div class="swiper-wrapper">
								<div class="swiper-slide">
									<!-- price Item Start -->
									<div class="price-item">
										<div class="icon-box">
											<img src="public/m/images/icon-ticker-1.svg" alt="">
										</div>

										<div class="price-body">
											<h4>Bitcoin</h4>
											<p>$121,601.00<span class="price-green">03.55%</span></p>
											<a href="#" class="btn-default">Order Now</a>
										</div>
									</div>
									<!-- Price Item End -->
								</div>

								<div class="swiper-slide">
									<!-- price Item Start -->
									<div class="price-item">
										<div class="icon-box">
											<img src="public/m/images/icon-ticker-2.svg" alt="">
										</div>

										<div class="price-body">
											<h4>Etherium</h4>
											<p>$12.185<span class="price-red">21.30%</span></p>
											<a href="#" class="btn-default">Order Now</a>
										</div>
									</div>
									<!-- Price Item End -->
								</div>

								<div class="swiper-slide">
									<!-- price Item Start -->
									<div class="price-item">
										<div class="icon-box">
											<img src="public/m/images/icon-ticker-3.svg" alt="">
										</div>

										<div class="price-body">
											<h4>Tether</h4>
											<p>$12.185<span class="price-green">21.30%</span></p>
											<a href="#" class="btn-default">Order Now</a>
										</div>
									</div>
									<!-- Price Item End -->
								</div>

								<div class="swiper-slide">
									<!-- price Item Start -->
									<div class="price-item">
										<div class="icon-box">
											<img src="public/m/images/icon-ticker-4.svg" alt="">
										</div>

										<div class="price-body">
											<h4>BNB</h4>
											<p>$12.185<span class="price-green">21.30%</span></p>
											<a href="#" class="btn-default">Order Now</a>
										</div>
									</div>
									<!-- Price Item End -->
								</div>	

								<div class="swiper-slide">
									<!-- price Item Start -->
									<div class="price-item">
										<div class="icon-box">
											<img src="public/m/images/icon-ticker-5.svg" alt="">
										</div>

										<div class="price-body">
											<h4>Solana</h4>
											<p>$12.185<span class="price-red">21.30%</span></p>
											<a href="#" class="btn-default">Order Now</a>
										</div>
									</div>
									<!-- Price Item End -->
								</div>	

								<div class="swiper-slide">
									<!-- price Item Start -->
									<div class="price-item">
										<div class="icon-box">
											<img src="public/m/images/icon-ticker-6.svg" alt="">
										</div>

										<div class="price-body">
											<h4>USD Coin</h4>
											<p>$12.185<span class="price-green">21.30%</span></p>
											<a href="#" class="btn-default">Order Now</a>
										</div>
									</div>
									<!-- Price Item End -->
								</div>

								<div class="swiper-slide">
									<!-- price Item Start -->
									<div class="price-item">
										<div class="icon-box">
											<img src="public/m/images/icon-ticker-7.svg" alt="">
										</div>

										<div class="price-body">
											<h4>Cardano</h4>
											<p>$12.185<span class="price-green">21.30%</span></p>
											<a href="#" class="btn-default">Order Now</a>
										</div>
									</div>
									<!-- Price Item End -->
								</div>

								<div class="swiper-slide">
									<!-- price Item Start -->
									<div class="price-item">
										<div class="icon-box">
											<img src="public/m/images/icon-ticker-8.svg" alt="">
										</div>

										<div class="price-body">
											<h4>Cardano</h4>
											<p>$12.185<span class="price-red">21.30%</span></p>
											<a href="#" class="btn-default">Order Now</a>
										</div>
									</div>
									<!-- Price Item End -->
								</div>

								<div class="swiper-slide">
									<!-- price Item Start -->
									<div class="price-item">
										<div class="icon-box">
											<img src="public/m/images/icon-ticker-9.svg" alt="">
										</div>

										<div class="price-body">
											<h4>Dogecoin</h4>
											<p>$12.185<span class="price-green">21.30%</span></p>
											<a href="#" class="btn-default">Order Now</a>
										</div>
									</div>
									<!-- Price Item End -->
								</div>

								<div class="swiper-slide">	
									<!-- price Item Start -->
									<div class="price-item">
										<div class="icon-box">
											<img src="public/m/images/icon-ticker-10.svg" alt="">
										</div>

										<div class="price-body">
											<h4>Tron</h4>
											<p>$12.185<span class="price-green">21.30%</span></p>
											<a href="#" class="btn-default">Order Now</a>
										</div>
									</div>
									<!-- Price Item End -->
								</div>

								<div class="swiper-slide">
									<!-- price Item Start -->
									<div class="price-item">
										<div class="icon-box">
											<img src="public/m/images/icon-ticker-11.svg" alt="">
										</div>

										<div class="price-body">
											<h4>Polygon</h4>
											<p>$12.185<span class="price-red">21.30%</span></p>
											<a href="#" class="btn-default">Order Now</a>
										</div>
									</div>
									<!-- Price Item End -->
								</div>

								<div class="swiper-slide">
									<!-- price Item Start -->
									<div class="price-item">
										<div class="icon-box">
											<img src="public/m/images/icon-ticker-12.svg" alt="">
										</div>

										<div class="price-body">
											<h4>Shiba INU</h4>
											<p>$12.185<span class="price-green">21.30%</span></p>
											<a href="#" class="btn-default">Order Now</a>
										</div>
									</div>
									<!-- Price Item End -->
								</div>
							</div>	
						</div>
					</div>
					<!-- Price Carousel End -->

					<!-- Price Carousel Start -->
					<div class="price-carousel price-carousel-right">
						<div class="swiper">
							<div class="swiper-wrapper">
								<div class="swiper-slide">
									<!-- price Item Start -->
									<div class="price-item">
										<div class="icon-box">
											<img src="public/m/images/icon-ticker-13.svg" alt="">
										</div>

										<div class="price-body">
											<h4>Lite Coin</h4>
											<p>$12.185<span class="price-red">21.30%</span></p>
											<a href="#" class="btn-default">Order Now</a>
										</div>
									</div>
									<!-- Price Item End -->
								</div>

								<div class="swiper-slide">
									<!-- price Item Start -->
									<div class="price-item">
										<div class="icon-box">
											<img src="public/m/images/icon-ticker-14.svg" alt="">
										</div>

										<div class="price-body">
											<h4>Stacks</h4>
											<p>$12.185<span class="price-green">21.30%</span></p>
											<a href="#" class="btn-default">Order Now</a>
										</div>
									</div>
									<!-- Price Item End -->
								</div>

								<div class="swiper-slide">
									<!-- price Item Start -->
									<div class="price-item">
										<div class="icon-box">
											<img src="public/m/images/icon-ticker-15.svg" alt="">
										</div>

										<div class="price-body">
											<h4>Toncoin</h4>
											<p>$12.185<span class="price-red">21.30%</span></p>
											<a href="#" class="btn-default">Order Now</a>
										</div>
									</div>
									<!-- Price Item End -->
								</div>

								<div class="swiper-slide">
									<!-- price Item Start -->
									<div class="price-item">
										<div class="icon-box">
											<img src="public/m/images/icon-ticker-16.svg" alt="">
										</div>

										<div class="price-body">
											<h4>Filecoin</h4>
											<p>$12.185<span class="price-green">21.30%</span></p>
											<a href="#" class="btn-default">Order Now</a>
										</div>
									</div>
									<!-- Price Item End -->
								</div>

								<div class="swiper-slide">
									<!-- price Item Start -->
									<div class="price-item">
										<div class="icon-box">
											<img src="public/m/images/icon-ticker-17.svg" alt="">
										</div>

										<div class="price-body">
											<h4>Hedera</h4>
											<p>$12.185<span class="price-red">21.30%</span></p>
											<a href="#" class="btn-default">Order Now</a>
										</div>
									</div>
									<!-- Price Item End -->
								</div>

								<div class="swiper-slide">
									<!-- price Item Start -->
									<div class="price-item">
										<div class="icon-box">
											<img src="public/m/images/icon-ticker-18.svg" alt="">
										</div>

										<div class="price-body">
											<h4>DigiByte</h4>
											<p>$12.185<span class="price-green">21.30%</span></p>
											<a href="#" class="btn-default">Order Now</a>
										</div>
									</div>
									<!-- Price Item End -->
								</div>

								<div class="swiper-slide">
									<!-- price Item Start -->
									<div class="price-item">
										<div class="icon-box">
											<img src="public/m/images/icon-ticker-19.svg" alt="">
										</div>

										<div class="price-body">
											<h4>Centrifuge</h4>
											<p>$12.185<span class="price-red">21.30%</span></p>
											<a href="#" class="btn-default">Order Now</a>
										</div>
									</div>
									<!-- Price Item End -->
								</div>

								<div class="swiper-slide">
									<!-- price Item Start -->
									<div class="price-item">
										<div class="icon-box">
											<img src="public/m/images/icon-ticker-20.svg" alt="">
										</div>

										<div class="price-body">
											<h4>Flux</h4>
											<p>$12.185<span class="price-green">21.30%</span></p>
											<a href="#" class="btn-default">Order Now</a>
										</div>
									</div>
									<!-- Price Item End -->
								</div>

								<div class="swiper-slide">
									<!-- price Item Start -->
									<div class="price-item">
										<div class="icon-box">
											<img src="public/m/images/icon-ticker-21.svg" alt="">
										</div>

										<div class="price-body">
											<h4>Compound</h4>
											<p>$12.185<span class="price-red">21.30%</span></p>
											<a href="#" class="btn-default">Order Now</a>
										</div>
									</div>
									<!-- Price Item End -->
								</div>

								<div class="swiper-slide">
									<!-- price Item Start -->
									<div class="price-item">
										<div class="icon-box">
											<img src="public/m/images/icon-ticker-22.svg" alt="">
										</div>

										<div class="price-body">
											<h4>Frax Share</h4>
											<p>$12.185<span class="price-green">21.30%</span></p>
											<a href="#" class="btn-default">Order Now</a>
										</div>
									</div>
									<!-- Price Item End -->
								</div>

								<div class="swiper-slide">
									<!-- price Item Start -->
									<div class="price-item">
										<div class="icon-box">
											<img src="public/m/images/icon-ticker-23.svg" alt="">
										</div>

										<div class="price-body">
											<h4>Gemini Dollar</h4>
											<p>$12.185<span class="price-green">21.30%</span></p>
											<a href="#" class="btn-default">Order Now</a>
										</div>
									</div>
									<!-- Price Item End -->
								</div>

								<div class="swiper-slide">
									<!-- price Item Start -->
									<div class="price-item">
										<div class="icon-box">
											<img src="public/m/images/icon-ticker-24.svg" alt="">
										</div>

										<div class="price-body">
											<h4>Maker</h4>
											<p>$12.185<span class="price-red">21.30%</span></p>
											<a href="#" class="btn-default">Order Now</a>
										</div>
									</div>
									<!-- Price Item End -->
								</div>
							</div>	
						</div>
					</div>
					<!-- Price Carousel End -->
				</div>
			</div>
		</div>
	</div>
	<!-- Price Section End -->

	<!-- Intro Video Section Start -->
	<div class="intro-video">
		<div class="container">
			<div class="row">
				<div class="col-md-12">
					<!-- Section Title Start -->
					<div class="section-title">
						<h3 class="wow fadeInUp">Our Dashboard</h3>
						<h2 class="text-anime">Watch Our Demo Video</h2>
					</div>
					<!-- Section Title End -->
				</div>
			</div>

			<div class="row">
				<div class="col-md-12">
					<!-- Intro Video Box Start -->
					<div class="intro-video-box">
						<div class="intro-video-image">
							<img src="public/m/images/video-bg.png" alt="">
						</div>

						<div class="video-play-button">
							<a href="https://www.youtube.com/watch?v=Y-x0efG1seA" class="popup-video">
								<img src="public/m/images/play.svg" alt="">
							</a>
						</div>
					</div>
					<!-- Intro Video Box End -->
				</div>
			</div>
		</div>
	</div>
	<!-- Intro Video Section End -->

	<!-- Why Choose us Section Start -->
	<div class="why-choose-us">
		<div class="container">
			<div class="row">
				<div class="col-md-12">
					<!-- Section Title Start -->
					<div class="section-title">
						<h3 class="wow fadeInUp">Why Choose us ?</h3>
						<h2 class="text-anime">Know More About <?php echo e($settings->site_name); ?></h2>
					</div>
					<!-- Section Title End -->
				</div>
			</div>

			<div class="row">
				<div class="col-md-4">
					<!-- Why Choose us Item Start -->
					<div class="why-choose-us-item wow fadeInUp" data-wow-delay="0.25s">
						<div class="icon-box">
							<img src="public/m/images/icon-why-choose-us-1.svg" alt="">
						</div>

						<h3>Safe & Secure</h3>
						<p>Bank-level protection for your assets.
							We use multi-signature wallets, cold storage, and 2FA to ensure your crypto stays safe from threats—so you can trade with peace of mind.
						</p>
					</div>
					<!-- Why Choose us Item End -->
				</div>

				<div class="col-md-4">
					<!-- Why Choose us Item Start -->
					<div class="why-choose-us-item wow fadeInUp" data-wow-delay="0.5s">
						<div class="icon-box">
							<img src="public/m/images/icon-why-choose-us-2.svg" alt="">
						</div>

						<h3>Early Bonus</h3>
						<p>Join now, earn more.
							New users get a 10% bonus on their first deposit* to kickstart their trading journey. (*Limited time offer.)
						</p>
					</div>
					<!-- Why Choose us Item End -->
				</div>

				<div class="col-md-4">
					<!-- Why Choose us Item Start -->
					<div class="why-choose-us-item wow fadeInUp" data-wow-delay="0.75s">
						<div class="icon-box">
							<img src="public/m/images/icon-why-choose-us-3.svg" alt="">
						</div>

						<h3>Several Profit</h3>
						<p>Grow your portfolio smarter.
							Stake, trade, or earn passive income with our yield tools—all under one roof.
						</p>
					</div>
					<!-- Why Choose us Item End -->
				</div>
			</div>
		</div>
	</div>
	<!-- Why Choose us Section End -->

	<!-- Download Apps Section Start -->
	<div class="download-apps">
		<div class="container">
			<div class="row align-items-center">
				<div class="col-lg-6 col-md-12">
					<!-- Download App Content Start -->
					<div class="download-apps-content">
						<!-- Section Title Start -->
						<div class="section-title">
							<h3 class="wow fadeInUp">Download App</h3>
							<h2 class="text-anime">Download Bitcoin App</h2>
						</div>
						<!-- Section Title End -->

						<!-- Download App Body Start -->
						<div class="download-app-body wow fadeInUp" data-wow-delay="0.25s">
							<p>Get our app on PC or mobile to create, send, and receive cryptocurrencies instantly.</p>
						</div>
						<!-- Download App Body End -->
					</div>
					<!-- Download App Content End -->
				</div>

				<div class="col-lg-3 col-md-6">
					<!-- Download App Item Start -->
					<div class="download-app-item wow fadeInUp" data-wow-delay="0.5s">
						<h3>Get App for IOS</h3>
						<a href="#" class="btn-default"><i class="fa-brands fa-app-store"></i> Download Now</a>
						
						<div class="download-app-img">
							<img src="public/m/images/mobile-img.png" alt="">
						</div>
					</div>
					<!-- Download App Item End -->
				</div>

				<div class="col-lg-3 col-md-6">
					<!-- Download App Item Start -->
					<div class="download-app-item wow fadeInUp" data-wow-delay="0.75s">
						<h3>Get App for IOS</h3>
						<a href="#" class="btn-default"><i class="fa-brands fa-google-play"></i> Download Now</a>
						
						<div class="download-app-img">
							<img src="public/m/images/mobile-img.png" alt="">
						</div>
					</div>
					<!-- Download App Item End -->
				</div>
			</div>
		</div>
	</div>
	<!-- Download Apps Section End -->

	<!-- Crypto Calculator Section Start -->
	<div class="crypto-calculator">
		<div class="container">
			<div class="row">
				<div class="col-md-12">
					<!-- Crypto Calculator Box Start -->
					<div class="crypto-calculator-box">
						<div class="row">
							<div class="col-md-12">
								<!-- Section Title Start -->
								<div class="section-title">
									<h3 class="wow fadeInUp">Bitcoin Calculator</h3>
									<h2 class="text-anime">Buy Cryptocurrency</h2>
								</div>
								<!-- Section Title End -->
							</div>
						</div>
<style>
    :root {
    --primary-colorr: #a29bfe;
    --secondary-colorr: #6c5ce7;
    --text-colorr: #f5f6fa;
    --bg-colorr: #1e272e;
    --card-colorr: #2d3436;
    --border-colorr: #636e72;
    --shadow: 0 4px 12px rgba(0, 0, 0, 0.2);
}

[data-theme="dark"] {
    --primary-colorr: #a29bfe;
    --secondary-colorr: #6c5ce7;
    --text-colorr: #f5f6fa;
    --bg-colorr: #1e272e;
    --card-colorr: #2d3436;
    --border-colorr: #636e72;
    --shadow: 0 4px 12px rgba(0, 0, 0, 0.2);
}

* {
    margin: 0;
    padding: 0;
    transition: background-color 0.3s, color 0.3s;
}

bodyy {
    font-family: 'Poppins', sans-serif;
    background-color: var(--bg-colorr);
    color: var(--text-colorr);
    line-height: 1.6;
}

.last-updated {
    font-size: 0.9rem;
    color: var(--secondary-colorr);
}

.converter-card {
    background-color: var(--card-colorr);
    border-radius: 16px;
    padding: 30px;
    box-shadow: var(--shadow);
    margin-bottom: 30px;
}

.card-header {
    display: flex;
    justify-content: space-between;
    align-items: center;
    margin-bottom: 25px;
}

.card-header h2 {
    font-size: 1.5rem;
    font-weight: 600;
}

.theme-toggle {
    cursor: pointer;
    width: 40px;
    height: 40px;
    border-radius: 50%;
    display: flex;
    align-items: center;
    justify-content: center;
    background-color: var(--bg-colorr);
}

.theme-toggle i {
    font-size: 1.2rem;
    color: var(--primary-colorr);
}

.converter-form {
    display: flex;
    flex-direction: column;
    gap: 20px;
}

.input-group {
    display: flex;
    gap: 20px;
}

.amount-input, .currency-select {
    flex: 1;
}

label {
    display: block;
    margin-bottom: 8px;
    font-size: 0.9rem;
    font-weight: 500;
}

input, select {
    width: 100%;
    padding: 12px 15px;
    border: 1px solid var(--border-colorr);
    border-radius: 8px;
    font-size: 1rem;
    background-color: var(--card-colorr);
    color: var(--text-colorr);
}

input:focus, select:focus {
    outline: none;
    border-color: var(--primary-colorr);
    box-shadow: 0 0 0 2px rgba(108, 92, 231, 0.2);
}

input[readonly] {
    background-color: var(--bg-colorr);
}

.swap-btn {
    align-self: center;
    width: 50px;
    height: 50px;
    border-radius: 50%;
    display: flex;
    align-items: center;
    justify-content: center;
    background-color: var(--primary-colorr);
    color: white;
    cursor: pointer;
    transition: transform 0.3s;
}

.swap-btn:hover {
    transform: rotate(180deg);
}

.conversion-details {
    margin-top: 30px;
}

.rate-info {
    display: flex;
    justify-content: space-between;
    align-items: center;
    margin-bottom: 20px;
}

.rate-change {
    padding: 5px 10px;
    border-radius: 20px;
    font-size: 0.8rem;
    font-weight: 500;
}

.rate-change.positive {
    background-color: rgba(0, 184, 148, 0.1);
    color: var(--positive-colorr);
}

.rate-change.negative {
    background-color: rgba(214, 48, 49, 0.1);
    color: var(--negative-colorr);
}

.historical-chart {
    height: 200px;
    margin-top: 20px;
}

.additional-features {
    display: grid;
    grid-template-columns: 1fr 1fr;
    gap: 20px;
}

.feature-card {
    background-color: var(--card-colorr);
    border-radius: 16px;
    padding: 25px;
    box-shadow: var(--shadow);
}

.feature-card h3 {
    margin-bottom: 20px;
    font-size: 1.2rem;
    font-weight: 600;
}

.popular-list {
    display: grid;
    grid-template-columns: 1fr 1fr;
    gap: 15px;
}

.popular-item {
    padding: 12px;
    border-radius: 8px;
    background-color: var(--bg-colorr);
    cursor: pointer;
    transition: all 0.2s;
}

.popular-item:hover {
    transform: translateY(-2px);
    box-shadow: 0 4px 8px rgba(0, 0, 0, 0.1);
}

.popular-item .pair {
    font-size: 0.9rem;
    color: var(--secondary-colorr);
    margin-bottom: 5px;
}

.popular-item .rate {
    font-weight: 600;
}

.crypto-table {
    overflow-x: auto;
}

table {
    width: 100%;
    border-collapse: collapse;
}

th, td {
    padding: 12px 15px;
    text-align: left;
    border-bottom: 1px solid var(--border-colorr);
}

th {
    font-weight: 600;
    font-size: 0.9rem;
    color: var(--secondary-colorr);
}

tr:hover {
    background-color: var(--bg-colorr);
}

.positive {
    color: var(--positive-colorr);
}

.negative {
    color: var(--negative-colorr);
}

footer {
    margin-top: 50px;
    text-align: center;
    font-size: 0.9rem;
    color: var(--secondary-colorr);
}

footer a {
    color: var(--primary-colorr);
    text-decoration: none;
}

footer a:hover {
    text-decoration: underline;
}

@media (max-width: 720px) {
    .input-group {
        flex-direction: column;
    }

    .additional-features {
        grid-template-columns: 1fr;
    }

    .popular-list {
        grid-template-columns: 1fr;
    }
}
</style>
						<div class="row">
							<div class="col-md-12">
								<div class="converter-form">
								    <div class="last-updated" id="lastUpdated"></div>
                    <main>
            <div class="converter-card">
                <div class="card-header">
                    <h2>Cryptocurrency Converter</h2>
                    <div class="theme-toggle">
                        <i class="fas fa-moon" id="themeIcon"></i>
                    </div>
                </div>

                <div class="converter-form">
                    <div class="input-group">
                        <div class="amount-input">
                            <label for="amount">Amount</label>
                            <input type="number" id="amount" value="1" min="0" step="0.00000001">
                        </div>
                        <div class="currency-select">
                            <label for="fromCurrency">From</label>
                            <select id="fromCurrency">
                                <option value="bitcoin">Bitcoin (BTC)</option>
                                <option value="ethereum">Ethereum (ETH)</option>
                                <option value="tether">Tether (USDT)</option>
                                <option value="usd" selected>US Dollar (USD)</option>
                            </select>
                        </div>
                    </div>

                    <div class="swap-btn" id="swapBtn">
                        <i class="fas fa-exchange-alt"></i>
                    </div>

                    <div class="input-group">
                        <div class="amount-input">
                            <label for="convertedAmount">Converted Amount</label>
                            <input type="number" id="convertedAmount" readonly>
                        </div>
                        <div class="currency-select">
                            <label for="toCurrency">To</label>
                            <select id="toCurrency">
                                <option value="bitcoin" selected>Bitcoin (BTC)</option>
                                <option value="ethereum">Ethereum (ETH)</option>
                                <option value="tether">Tether (USDT)</option>
                                <option value="usd">US Dollar (USD)</option>
                                                            </select>
                        </div>
                    </div>
                </div>

                <div class="conversion-details">
                    <div class="rate-info">
                        <span id="rateText">1 USD = 0.000025 BTC</span>
                        <span class="rate-change" id="rateChange"><i class="fas fa-caret-up"></i> 0.5%</span>
                    </div>
                    <div class="historical-chart">
                        <canvas id="chart"></canvas>
                    </div>
                </div>
            </div>

            <div class="conversion-details">
                <div class="feature-card popular-currencies">
                    <h3>Popular Conversions</h3>
                    <div class="popular-list" id="popularConversions">
                        <!-- Filled by JavaScript -->
                    </div>
                </div>

                <div class="conversion-details">
                    <h3>Top Cryptocurrencies</h3>
                    <div class="crypto-table">
                        <table id="topCryptos">
                            <thead>
                                <tr>
                                    <th>#</th>
                                    <th>Name</th>
                                    <th>Price</th>
                                    <th>24h Change</th>
                                    <th>Market Cap</th>
                                </tr>
                            </thead>
                            <tbody>
                                <!-- Filled by JavaScript -->
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </main>

							</div>
						</div>
					</div>
					<!-- Crypto Calculator Box End -->
				</div>
			</div>
		</div>
	</div>
	</div>
	<!-- Crypto Calculator Section End -->

	<!-- Our Team Section Start -->
	<div class="our-team">
		<div class="container">
			<div class="row">
				<div class="col-md-12">
					<!-- Section Title Start -->
					<div class="section-title">
						<h3 class="wow fadeInUp">Our Team</h3>
						<h2 class="text-anime">Our Crypto Exchange Experts</h2>
					</div>
					<!-- Section Title End -->
				</div>
			</div>

			<div class="row">
				<div class="col-lg-3 col-md-6">
					<!-- Team Item Start -->
					<div class="team-item wow fadeInUp" data-wow-delay="0.25s">
						<div class="team-image-links">
							<!-- Team Image Start -->
							<div class="team-image">
								<figure>
									<img src="public/m/images/team-1.png" alt="">
								</figure>
							</div>
							<!-- Team Image End -->

							<!-- Team Social Links Start -->
							<div class="team-social-links">
								<ul>
									<li><a href="#"><i class="fa-brands fa-facebook-f"></i></a></li>
									<li><a href="#"><i class="fa-brands fa-twitter"></i></a></li>
									<li><a href="#"><i class="fa-brands fa-instagram"></i></a></li>
									<li><a href="#"><i class="fa-brands fa-linkedin-in"></i></a></li>
								</ul>
							</div>
							<!-- Team Social Links End -->
						</div>

						<!-- Team Info Start -->
						<div class="team-info">
							<h3>John Doe</h3>
							<p>(Founder & CEO)</p>
						</div>
						<!-- Team Info End -->
					</div>
					<!-- Team Item End -->
				</div>

				<div class="col-lg-3 col-md-6">
					<!-- Team Item Start -->
					<div class="team-item wow fadeInUp" data-wow-delay="0.5s">
						<div class="team-image-links">
							<!-- Team Image Start -->
							<div class="team-image">
								<figure>
									<img src="public/m/images/team-2.png" alt="">
								</figure>
							</div>
							<!-- Team Image End -->

							<!-- Team Social Links Start -->
							<div class="team-social-links">
								<ul>
									<li><a href="#"><i class="fa-brands fa-facebook-f"></i></a></li>
									<li><a href="#"><i class="fa-brands fa-twitter"></i></a></li>
									<li><a href="#"><i class="fa-brands fa-instagram"></i></a></li>
									<li><a href="#"><i class="fa-brands fa-linkedin-in"></i></a></li>
								</ul>
							</div>
							<!-- Team Social Links End -->
						</div>

						<!-- Team Info Start -->
						<div class="team-info">
							<h3>Marco Verratti</h3>
							<p>(Senior Consultant)</p>
						</div>
						<!-- Team Info End -->
					</div>
					<!-- Team Item End -->
				</div>

				<div class="col-lg-3 col-md-6">
					<!-- Team Item Start -->
					<div class="team-item wow fadeInUp" data-wow-delay="0.75s">
						<div class="team-image-links">
							<!-- Team Image Start -->
							<div class="team-image">
								<figure>
									<img src="public/m/images/team-3.png" alt="">
								</figure>
							</div>
							<!-- Team Image End -->

							<!-- Team Social Links Start -->
							<div class="team-social-links">
								<ul>
									<li><a href="#"><i class="fa-brands fa-facebook-f"></i></a></li>
									<li><a href="#"><i class="fa-brands fa-twitter"></i></a></li>
									<li><a href="#"><i class="fa-brands fa-instagram"></i></a></li>
									<li><a href="#"><i class="fa-brands fa-linkedin-in"></i></a></li>
								</ul>
							</div>
							<!-- Team Social Links End -->
						</div>

						<!-- Team Info Start -->
						<div class="team-info">
							<h3>Arita Banson</h3>
							<p>(Creative Manager)</p>
						</div>
						<!-- Team Info End -->
					</div>
					<!-- Team Item End -->
				</div>

				<div class="col-lg-3 col-md-6">
					<!-- Team Item Start -->
					<div class="team-item wow fadeInUp" data-wow-delay="1.0s">
						<div class="team-image-links">
							<!-- Team Image Start -->
							<div class="team-image">
								<figure>
									<img src="public/m/images/team-4.png" alt="">
								</figure>
							</div>
							<!-- Team Image End -->

							<!-- Team Social Links Start -->
							<div class="team-social-links">
								<ul>
									<li><a href="#"><i class="fa-brands fa-facebook-f"></i></a></li>
									<li><a href="#"><i class="fa-brands fa-twitter"></i></a></li>
									<li><a href="#"><i class="fa-brands fa-instagram"></i></a></li>
									<li><a href="#"><i class="fa-brands fa-linkedin-in"></i></a></li>
								</ul>
							</div>
							<!-- Team Social Links End -->
						</div>

						<!-- Team Info Start -->
						<div class="team-info">
							<h3>Banson Doe</h3>
							<p>(Senior Consultant)</p>
						</div>
						<!-- Team Info End -->
					</div>
					<!-- Team Item End -->
				</div>
			</div>
		</div>
	</div>
	<!-- Our Team Section End -->

	<!-- Testimonial Section Start -->
	<div class="testimonials">
		<div class="container-fluid">
			<div class="row no-gap">
				<div class="col-md-12">
					<!-- Section Title Start -->
					<div class="section-title">
						<h3 class="wow fadeInUp">Client Review</h3>
						<h2 class="text-anime">Client Testimonials</h2>
					</div>
					<!-- Section Title End -->
				</div>
			</div>

			<div class="row no-gap">
				<div class="col-md-12">
					<!-- Testimonial Carousel Start -->
					<div class="testimonial-carousel">
						<div class="swiper">
							<div class="swiper-wrapper">
								<div class="swiper-slide">
									<!-- Testimonial Item Start -->
									<div class="testimonial-item">
										<div class="testimonial-body">
											<p>I was nervous about trading, but <?php echo e($settings->site_name); ?> made it so simple. Their tutorials and 24/7 support helped me earn my first $1K in weeks!</p>
										</div>

										<div class="testimonial-header">
											<div class="author-image">
												<img src="public/m/images/author-1.jpg" alt="">
											</div>

											<div class="author-info">
												<h3>Olivia Bartlett</h3>
												<p>(Freelancer)</p>
											</div>
										</div>
									</div>
									<!-- Testimonial Item End -->
								</div>

								<div class="swiper-slide">
									<!-- Testimonial Item Start -->
									<div class="testimonial-item">
										<div class="testimonial-body">
											<p>The AI price alerts and lightning-fast execution give me an edge. I’ve doubled my daily trades since switching to <?php echo e($settings->site_name); ?>.</p>
										</div>

										<div class="testimonial-header">
											<div class="author-image">
												<img src="public/m/images/author-2.jpg" alt="">
											</div>

											<div class="author-info">
												<h3>Charles Park</h3>
												<p>(trader)</p>
											</div>
										</div>
									</div>
									<!-- Testimonial Item End -->
								</div>

								<div class="swiper-slide">
									<!-- Testimonial Item Start -->
									<div class="testimonial-item">
										<div class="testimonial-body">
											<p>With hacks everywhere, <?php echo e($settings->site_name); ?>’s cold storage and 2FA were deciding factors. My assets have never felt safer.</p>
										</div>

										<div class="testimonial-header">
											<div class="author-image">
												<img src="public/m/images/author-3.jpg" alt="">
											</div>

											<div class="author-info">
												<h3>Alison Banson</h3>
												<p>(Senior Consultant)</p>
											</div>
										</div>
									</div>
									<!-- Testimonial Item End -->
								</div>

								<div class="swiper-slide">
									<!-- Testimonial Item Start -->
									<div class="testimonial-item">
										<div class="testimonial-body">
											<p>I earn 12% APY staking Ethereum here—way higher than my old platform. Withdrawals take seconds, not days.</p>
										</div>

										<div class="testimonial-header">
											<div class="author-image">
												<img src="public/m/images/author-4.jpg" alt="">
											</div>

											<div class="author-info">
												<h3>Tracey Hawkins</h3>
												<p>(Investor)</p>
											</div>
										</div>
									</div>
									<!-- Testimonial Item End -->
								</div>

								<div class="swiper-slide">
									<!-- Testimonial Item Start -->
									<div class="testimonial-item">
										<div class="testimonial-body">
											<p>Low fees and multi-language support? Finally, an exchange that gets international traders!</p>
										</div>

										<div class="testimonial-header">
											<div class="author-image">
												<img src="public/m/images/author-5.jpg" alt="">
											</div>

											<div class="author-info">
												<h3>Christopher Case</h3>
												<p>(Senior Consultant)</p>
											</div>
										</div>
									</div>
									<!-- Testimonial Item End -->
								</div>

								<div class="swiper-slide">
									<!-- Testimonial Item Start -->
									<div class="testimonial-item">
										<div class="testimonial-body">
											<p><?php echo e($settings->site_name); ?>’s seamless bridge to DeFi protocols saves me hours. I access farming pools without juggling 10 wallets.</p>
										</div>

										<div class="testimonial-header">
											<div class="author-image">
												<img src="public/m/images/author-6.jpg" alt="">
											</div>

											<div class="author-info">
												<h3>Edward Johns</h3>
												<p>(Blogger)</p>
											</div>
										</div>
									</div>
									<!-- Testimonial Item End -->
								</div>
							</div>	
						</div>
					</div>
					<!-- Testimonial Carousel End -->
				</div>
			</div>
		</div>
	</div>
	<!-- Testimonial Section End -->

	

	<!-- Footer Start -->
	<footer class="main-footer">
		<div class="container">
			<div class="row">
				<div class="col-md-12">
					<!-- Footer Newsletters Start -->
					<div class="footer-newsletters">
						<div class="row">
							<div class="col-lg-6">
								<!-- Newsletter Title Start -->
								<div class="newsletter-title">
									<div class="icon-box">
										<img src="public/m/images/icon-stay-info.svg" alt="">
									</div>

									<h2>Stay Informed And Never Miss An <?php echo e($settings->site_name); ?> Update!</h2>
								</div>
								<!-- Newsletter Title End -->
							</div>

							<div class="col-lg-6">
								<!-- Newsletter Form Start -->
								<div class="newsletter-form">
									<form id="newsletter_form" action="#" data-toggle="validator">
										<div class="row no-gap align-items-center">
											<div class="form-group col-md-8">
												<input type="email" name="email" class="form-control" id="news_email" placeholder="Enter Your Email Address" required="">
												<div class="help-block with-errors"></div>
											</div>										
			
											<div class="col-md-4 text-end">
												<button type="submit" class="btn-default disabled">Subscribe Now</button>
												<div id="news_letter_Submit" class="h3 text-left hidden"></div>
											</div>
										</div>
									</form>
								</div>
								<!-- Newsletter Form End -->
							</div>
						</div>
					</div>
					<!-- Footer Newsletters End -->
				</div>
			</div>

			<div class="row">
				<div class="col-md-12">
					<!-- Mega Footer Start -->
					<div class="mega-footer">
						<div class="row">
							<div class="col-lg-3 col-12">
								<!-- Footer About Start -->
								<div class="footer-about">
									<!-- Footer Logo Start -->
									<div class="footer-logo">
										<img src="<?php echo e(asset('storage/app/public/'.$settings->logo)); ?>" alt="">
									</div>
									<!-- Footer Logo End -->

									<!-- Footer About Content Start -->
									<div class="footer-about-content">
										<p>At <?php echo e($settings->site_name); ?>, we prioritize your security above all. With trusted systems, advanced protection, and a commitment to reliability, we ensure your investments are always safe with our platform</p>
									</div>
									<!-- Footer About Content End -->

									<!-- Footer Social Links Start -->
									<div class="footer-social-links">
										<ul>
											<li><a href="#"><i class="fa-brands fa-facebook-f"></i></a></li>
											<li><a href="#"><i class="fa-brands fa-twitter"></i></a></li>
											<li><a href="#"><i class="fa-brands fa-instagram"></i></a></li>
											<li><a href="#"><i class="fa-brands fa-linkedin-in"></i></a></li>
										</ul>
									</div>
									<!-- Footer Social Links End -->
								</div>
								<!-- Footer About End -->
							</div>

							<div class="col-lg-3 col-md-4">
								<!-- Footer Links Start -->
								<div class="footer-links">
									<!-- Footer Title Start -->
									<div class="footer-title">
										<h3>Quick Links</h3>
									</div>
									<!-- Footer Title End -->
									
									<div class="footer-menu">
										<ul>
											<li><a href="/">Home</a></li>
											<li><a href="about">About Us</a></li>
											<li><a href="contact">Contact</a></li>
										</ul>
									</div>
								</div>
								<!-- Footer Links End -->
							</div>

							<div class="col-lg-3 col-md-4">
								<!-- Footer Links Start -->
								<div class="footer-links">
									<!-- Footer Title Start  -->
									<div class="footer-title">
										<h3>Accounts</h3>
									</div>
									<!-- Footer Title End -->
									
									<div class="footer-menu">
										<ul>
											<li><a href="login">Login</a></li>
											<li><a href="register">Create Account</a></li>
										</ul>
									</div>
								</div>
								<!-- Footer Links End -->
							</div>

							<div class="col-lg-3 col-md-4">
								<!-- Footer Contact information Start -->
								<div class="footer-contact-information">
									<!-- Footer Title Start -->
									<div class="footer-title">
										<h3>Contact Information</h3>
									</div>
									<!-- Footer Title End -->

									<div class="footer-contact-info">
										<!-- Footer Contact info Item Start -->
										<div class="footer-contact-info-item">
											<div class="icon-box">
												<i class="fa-solid fa-phone"></i>
											</div>

											<p><?php echo e($settings->whatsapp); ?></p>
										</div>
										<!-- Footer Contact info Item End -->

										<!-- Footer Contact info Item Start -->
										<div class="footer-contact-info-item">
											<div class="icon-box">
												<i class="fa-solid fa-envelope"></i>
											</div>

											<p><?php echo e($settings->contact_email); ?></p>
										</div>
										<!-- Footer Contact info Item End -->

										<!-- Footer Contact info Item Start -->
										<div class="footer-contact-info-item">
											<div class="icon-box">
												<i class="fa-solid fa-location-dot"></i>
											</div>

											<p><?php echo e($settings->address_o); ?></p>
										</div>
										<!-- Footer Contact info Item End -->
									</div>
								</div>
								<!-- Footer Contact information End -->
							</div>
						</div>
					</div>
					<!-- Mega Footer End -->
				</div>
			</div>

			<div class="row">
				<div class="col-md-12">
					<!-- Copyright Footer Start -->
					<div class="footer-copyrights">
						<div class="row align-items-center">
							<div class="col-md-6">
								<!-- Copyright Content Start -->
								<div class="footer-copyright">
									<p>Copyright &copy; 2025 <?php echo e($settings->site_name); ?>. All Rights Reserved.</p>
								</div>
								<!-- Copyright Content End -->
							</div>

							<div class="col-md-6">
								<!-- Footer Policy Menu Start -->
								<div class="footer-policy-menu">
									<ul>
										<li><a href="#">Privacy Policy</a></li>
										<li><a href="#">Terms of Use</a></li>
									</ul>
								</div>
								<!-- Footer Policy Menu End -->
							</div>
						</div>
					</div>
					<!-- Copyright Footer End -->
				</div>
			</div>
		</div>
	</footer>
	<!-- Footer End -->

	<!-- Jquery Library File -->
	<script src="public/m/js/jquery-3.7.1.min.js"></script>
	<!-- Bootstrap js file -->
	<script src="public/m/js/bootstrap.min.js"></script>
	<!-- Validator js file -->
	<script src="public/m/js/validator.min.js"></script>
	<script src="public/m/js/converterst.js"></script>
	<script src="https://cdn.jsdelivr.net/npm/chart.js"></script>
	<!-- SlickNav js file -->
	<script src="public/m/js/jquery.slicknav.js"></script>
	<!-- Swiper js file -->
	<script src="public/m/js/swiper-bundle.min.js"></script>
	<!-- Counter js file -->
	<script src="public/m/js/jquery.waypoints.min.js"></script>
	<script src="public/m/js/jquery.counterup.min.js"></script>
	<!-- Magnific js file -->
	<script src="public/m/js/jquery.magnific-popup.min.js"></script>
	<!-- SmoothScroll -->
	<script src="public/m/js/SmoothScroll.js"></script>
	<!-- Parallax js -->
	<script src="public/m/js/parallaxie.js"></script>
	<!-- MagicCursor js file -->
	<script src="public/m/js/gsap.min.js"></script>
	<script src="public/m/js/magiccursor.js"></script>
	<!-- Text Effect js file -->
	<script src="public/m/js/splitType.js"></script>
	<script src="public/m/js/ScrollTrigger.min.js"></script>
	<!-- YTPlayer js file -->
	<script src="public/m/js/jquery.mb.YTPlayer.min.js"></script>
	<!-- Wow js file -->
	<script src="public/m/js/wow.js"></script>
	<!-- Main Custom js file -->
	<script src="public/m/js/function.js"></script>
</body>

<!-- Smartsupp Live Chat script -->
<script type="text/javascript">
var _smartsupp = _smartsupp || {};
_smartsupp.key = '7381b0d0128b5adc297424eec23e683345a9a164';
window.smartsupp||(function(d) {
  var s,c,o=smartsupp=function(){ o._.push(arguments)};o._=[];
  s=d.getElementsByTagName('script')[0];c=d.createElement('script');
  c.type='text/javascript';c.charset='utf-8';c.async=true;
  c.src='https://www.smartsuppchat.com/loader.js?';s.parentNode.insertBefore(c,s);
})(document);
</script>
<noscript>Powered by <a href="https://www.smartsupp.com" target="_blank">Smartsupp</a></noscript>


</html><?php /**PATH /home/atlasca1/public_html/resources/views/home/index.blade.php ENDPATH**/ ?>