<?php

use App\Http\Controllers\Auth\ApiAuthController;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Route;

/*
|--------------------------------------------------------------------------
| API Routes
|--------------------------------------------------------------------------
|
| Here is where you can register API routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| is assigned the "api" middleware group. Enjoy building your API!
|
*/

Route::post('/create-account', [ApiAuthController::class, 'register']);
Route::middleware('auth:sanctum')->get('/user', function (Request $request) {
    return $request->user();
});

// User's Notifications API Routes
Route::middleware('auth:sanctum')->group(function () {
    Route::get('/notifications', 'App\Http\Controllers\User\NotificationController@getLatest');
    Route::get('/notifications/unread-count', 'App\Http\Controllers\User\NotificationController@getUnreadCount');
});