"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
Object.defineProperty(exports, "default", {
    enumerable: true,
    get: function() {
        return TokenManagementClient;
    }
});
const _metaApiclient = /*#__PURE__*/ _interop_require_default(require("../metaApi.client"));
function _interop_require_default(obj) {
    return obj && obj.__esModule ? obj : {
        default: obj
    };
}
let TokenManagementClient = class TokenManagementClient extends _metaApiclient.default {
    /**
   * Gets access rules manifest
   * @returns {Promise<Array<ManifestAccessRule>>} access rules manifest
   */ getAccessRules() {
        if (this._isNotJwtToken()) {
            return this._handleNoAccessError("getAccessRules");
        }
        const opts = {
            url: `${this._host}/access-rule-manifest`,
            method: "GET",
            headers: {
                "auth-token": this._token
            },
            json: true
        };
        return this._httpClient.request(opts, "getAccessRules");
    }
    /**
   * Returns narrowed down token with given access rules
   * @param {NarrowDownAccessRules | NarrowDownSimplifiedAccessRules} narrowDownPayload narrow down payload
   * @param {Number} [validityInHours] token validity in hours
   * @return {Promise<NarrowedDownToken>} promise resolving with narrowed down token
   */ narrowDownToken(accessRules, validityInHours) {
        if (this._isNotJwtToken()) {
            return this._handleNoAccessError("narrowDownToken");
        }
        if (validityInHours) {
            validityInHours = `?validity-in-hours=${validityInHours}`;
        }
        const opts = {
            url: `${this._host}/users/current/narrow-down-auth-token${validityInHours || ""}`,
            method: "POST",
            headers: {
                "auth-token": this._token
            },
            json: true,
            data: accessRules
        };
        return this._httpClient.request(opts, "narrowDownToken");
    }
    /**
   * Access rules manifest
   * @typedef {Object} ManifestAccessRule
   * @property {String} id application id
   * @property {String} application application name
   * @property {String} description application description
   * @property {Array<ManifestEntity>} entities application resources entities
   * @property {Array<ManifestService>} services application services
   * @property {Array<ManifestMethodGroup>} methodGroups application method groups
   * @property {Array<ManifestRoles>} roles application roles
   * @property {String} [entityCompositionDescription] application entity composition description
   */ /**
   * Access rules manifest resource entity
   * @typedef {Object} ManifestEntity
   * @property {String} description entity description
   * @property {String} entity entity name
   * @property {String} [idDescription] entity id description
   */ /**
   * Access rules manifest application service
   * @typedef {Object} ManifestService
   * @property {String} description service description
   * @property {String} service service name
   */ /**
   * Access rules manifest application method group
   * @typedef {Object} ManifestMethodGroup
   * @property {String} group method group name
   * @property {String} description method group description
   * @property {Array<ManifestMethod>} methods method group methods
   */ /**
   * Access rules manifest application method
   * @typedef {Object} ManifestMethod
   * @property {String} description method description
   * @property {Array<String>} method method name
   * @property {Array<String>} [scopes] method scopes
   */ /**
   * Access rules manifest application roles
   * @typedef {Object} ManifestRoles
   * @property {String} description application roles description
   * @property {Array<String>} roles application roles
   */ /**
   * Narrowed down token access rules
   * @typedef {Object} NarrowDownAccessRules
   * @property {Array<AccessRule>} accessRules applications access rules to grant
   */ /**
   * Narrowed down token simplified access rules
   * @typedef {Object} NarrowDownSimplifiedAccessRules
   * @property {Array<AccessRuleResource>} [resources] resources to grant access to
   * @property {Array<String>} [roles] roles to grant access to
   * @property {Array<String>} [applications] applications to grant access to
   */ /**
   * Narrowed down token access rule
   * @typedef {Object} AccessRule
   * @property {String} id application id to grant access to
   * @property {String} application application to grant access to
   * @property {String} service application service to grant access to
   * @property {Array<MethodGroups>} methodGroups application service methodGroups to
   * grant access to
   * @property {Array<AccessRuleResource>} resources application service resources 
   * to grant access to
   * @property {Array<String>} roles access rule roles to grant access to
   */ /**
   * Narrowed token access rule method groups 
   * @typedef {Object} MethodGroups
   * @property {String} group method group
   * @property {Array<Method>} methods method group methods
   */ /**
   * Method group method
   * @typedef {Object} Method
   * @property {String} method method
   * @property {Array<String>} [scopes] method scopes
   */ /**
   * Narrowed token access rule resource 
   * @typedef {Object} AccessRuleResource
   * @property {String} entity entity
   * @property {String} id entity id
   */ /**
   * New narrowed down token model
   * @typedef {Object} NarrowedDownToken
   * @property {String} token authorization token value
   */ /**
   * Constructs token management API client instance
   * @param {HttpClient} httpClient HTTP client
   * @param {DomainClient} domainClient domain client
   */ constructor(httpClient, domainClient){
        super(httpClient, domainClient);
        this._host = `https://profile-api-v1.${domainClient.domain}`;
    }
};

//# sourceMappingURL=data:application/json;base64,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