"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
Object.defineProperty(exports, /**
 * MetaApi CopyFactory copy trading API SDK
 */ "default", {
    enumerable: true,
    get: function() {
        return CopyFactory;
    }
});
const _httpClient = /*#__PURE__*/ _interop_require_default(require("./clients/httpClient"));
const _configurationclient = /*#__PURE__*/ _interop_require_default(require("./clients/copyfactory/configuration.client"));
const _historyclient = /*#__PURE__*/ _interop_require_default(require("./clients/copyfactory/history.client"));
const _tradingclient = /*#__PURE__*/ _interop_require_default(require("./clients/copyfactory/trading.client"));
const _domainclient = /*#__PURE__*/ _interop_require_default(require("./clients/domain.client"));
const _logger = /*#__PURE__*/ _interop_require_default(require("./logger"));
function _interop_require_default(obj) {
    return obj && obj.__esModule ? obj : {
        default: obj
    };
}
let CopyFactory = class CopyFactory {
    _domain;
    _httpClient;
    _domainClient;
    _configurationClient;
    _historyClient;
    _tradingClient;
    /**
   * Enables using Log4js logger with extended log levels for debugging instead of
   * console.* functions. Note that log4js configuration performed by the user.
   */ static enableLog4jsLogging() {
        _logger.default.useLog4js();
    }
    /**
   * Constructs CopyFactory class instance
   * @param {String} token authorization token
   * @param {Object} opts connection options
   * @param {String} [opts.domain] domain to connect to
   * @param {String} [opts.extendedTimeout] timeout for extended http requests in seconds
   * @param {Number} [opts.requestTimeout] timeout for http requests in seconds
   */ constructor(token, opts = {}){
        this._domain = opts.domain || "agiliumtrade.agiliumtrade.ai";
        let requestTimeout = opts.requestTimeout || 10;
        let requestExtendedTimeout = opts.extendedTimeout || 70;
        const retryOpts = opts.retryOpts || {};
        this._httpClient = new _httpClient.default(requestTimeout, requestExtendedTimeout, retryOpts);
        this._domainClient = new _domainclient.default(this._httpClient, token, this._domain);
        this._configurationClient = new _configurationclient.default(this._domainClient);
        this._historyClient = new _historyclient.default(this._domainClient);
        this._tradingClient = new _tradingclient.default(this._domainClient, this._configurationClient);
    }
    /**
   * Returns CopyFactory configuration API
   * @returns {ConfigurationClient} configuration API
   */ get configurationApi() {
        return this._configurationClient;
    }
    /**
   * Returns CopyFactory history API
   * @return {HistoryClient} history API
   */ get historyApi() {
        return this._historyClient;
    }
    /**
   * Returns CopyFactory trading API
   * @return {TradingClient} trading API
   */ get tradingApi() {
        return this._tradingClient;
    }
};

//# sourceMappingURL=data:application/json;base64,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